/***************************************************************************
 * launcher
 * Copyright (C) 2013 Blizzard Entertainment
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***************************************************************************/

#ifndef UTILS_INCLUDED
#define UTILS_INCLUDED
#pragma once

#include <utility>


#ifdef _MSC_VER
// Visual studio doesn't support constexpr yet.  We have to do it the ghetto way.
#define lengthof(a) (sizeof(a) / sizeof(a[0]))
#else
template <class T, size_t size>
constexpr size_t lengthof(const T (&a)[size])
{
    return size;
}
#endif

// scope guard macro -- schedules an operation for execution when exiting the current scope
#define at_scope_exit(cb) auto CONCAT(_scope_exit_, __COUNTER__) = do_at_scope_exit(cb)

#define CONCAT(a, b) CONCAT2(a, b)
#define CONCAT2(a, b) a ## b

template <class Callable>
class scope_exit_guard
{
public:
    scope_exit_guard(Callable cb) : cb(cb), valid(true) { }
    scope_exit_guard(scope_exit_guard&& other) : cb(std::move(other.cb)), valid(std::move(other.valid)) { other.valid = false; }
    ~scope_exit_guard() { if (valid) cb(); }
private:
    scope_exit_guard(const scope_exit_guard&);

private:
    Callable cb;
    bool valid;
};

template <class Callable>
scope_exit_guard<Callable> do_at_scope_exit(Callable cb)
{
    return scope_exit_guard<Callable>(cb);
}

#endif
